#!/bin/bash
shopt -s extglob nullglob

# Check if a directory list file was provided as an argument
if [ $# -ne 1 ]; then
  echo "Usage: $0 dirs_list_file"
  exit 1
fi

# Enable extended pattern matching and nullglob
shopt | grep extglob
dirs_to_process="$1"

# Read the list of directories to process into an array
mapfile -t dirs_array < "$dirs_to_process"

total_dirs=${#dirs_array[@]}
processed_count=0

# Define the processing function
process_dir() {
  dir="$1"
  target_dir="../../ht_selex/kmap_res"  # Target directory, same as in generate_dirs.sh
  output_dir="$target_dir/$dir"
  fasta_dir="../../ht_selex/fasta"
  fasta_file="$fasta_dir/$dir.fasta"

  # Run the preprocessing and motif scanning commands
  kmap preproc --fasta_file "$fasta_file" --res_dir "$output_dir/res_dir"
  kmap scan_motif --res_dir "$output_dir/res_dir"
  kmap visualize_kmers --res_dir "$output_dir/res_dir"

  echo "Finished processing directory: $dir"
}

# Process each directory in order and display progress information
for dir in "${dirs_array[@]}"; do
  ((processed_count++))
  remaining=$((total_dirs - processed_count))
  echo "Processing directory $processed_count/$total_dirs, $remaining remaining."
  process_dir "$dir"
done
